// ops-header-Lagerverwaltung.js (DEMO Header: correct layout + DEMO badge + Reset + DE/EN)
(() => {
  "use strict";

  // Mark demo globally (used by lagerverwaltung patch)
  window.OPS_DEMO = true;

  let timeTimer = null;

function ensureCss(href) {
  const base = href.replace(/\?.*$/, "");
  // vorhandene Links auf diese CSS entfernen (damit wir neu laden können)
  document.querySelectorAll('link[rel="stylesheet"]').forEach(l => {
    const h = (l.getAttribute("href") || "");
    if (h.includes(base)) l.remove();
  });

  const link = document.createElement("link");
  link.rel = "stylesheet";
  link.href = "./" + base + "?v=" + Date.now(); // Cache-Bust
  document.head.appendChild(link);
}
ensureCss("ops.css");
ensureCss("ops-Lagerverwaltung.css");
ensureCss("ops-header.css");


  // In deiner HTML ist ops-header.css nicht verlinkt – für Header-Styling optional nachladen
  // ops.css + ops-Lagerverwaltung.css sind schon im HTML, aber schadet nicht als Fallback.
  ensureCss("ops.css");
  ensureCss("ops-Lagerverwaltung.css");
  ensureCss("ops-header.css");

  // DEMO pill style (nur Zusatz)
  if (!document.getElementById("opsDemoStyle")) {
    const s = document.createElement("style");
    s.id = "opsDemoStyle";
    s.textContent = `
      .demo-pill{
        background: rgba(220,38,38,.16) !important;
        border: 1px solid rgba(220,38,38,.55) !important;
        color: rgba(254,226,226,.98) !important;
        font-weight: 800;
        letter-spacing: .08em;
      }
    `;
    document.head.appendChild(s);
  }

  function getLang() {
    try { if (typeof window.getOpsLang === "function") return window.getOpsLang(); } catch (_) {}
    const l = String(document.documentElement.lang || "de").toLowerCase();
    return l.startsWith("en") ? "en" : "de";
  }

  function t(de, en) {
    try { if (typeof window.tLang === "function") return window.tLang(de, en); } catch (_) {}
    return getLang() === "en" ? (en ?? de) : (de ?? en);
  }

  function fmtDateTime(d) {
    const pad = (n) => String(n).padStart(2, "0");
    return pad(d.getDate()) + "." + pad(d.getMonth() + 1) + "." + d.getFullYear() + " " + pad(d.getHours()) + ":" + pad(d.getMinutes());
  }

  async function fetchMe() {
    // Demo: wenn OpsOffline.me existiert, nutzen. Sonst Demo-User.
    try {
      if (window.OpsOffline && typeof window.OpsOffline.me === "function") {
        const m = await window.OpsOffline.me();
        if (m) return m;
      }
    } catch (_) {}
    return { username: "demo", roles: ["admin"] };
  }

  function buildHeader(me) {
    const host = location.host;
    const userLabel = me?.username ? me.username : "demo";
    const roles = Array.isArray(me?.roles) ? me.roles : ["admin"];
    const roleText = roles.length ? roles.join(", ") : "";
    const lang = getLang();

    // WICHTIG: diese Struktur matcht ops.css (Header Layout wie in Anlage 1)
    return `
      <div class="header-brand">
        <div class="header-logo">OD</div>
        <div class="header-title">
          <span class="header-title-main">OpsDeck360</span>
          <span class="header-title-sub">${t("Lokaler Server", "Local server")} • ${host}</span>
        </div>
        <span class="header-pill demo-pill">DEMO</span>
      </div>

      <div class="header-nav"><!-- optional navigation --></div>

      <div class="header-right">
        <span class="header-pill" id="opsHdrTime"></span>
        <span class="header-pill">${t("User","User")}: <b>${userLabel}</b> <span style="opacity:.75;">(${roleText})</span></span>

        <button id="opsHdrReset" class="btn btn-ghost" type="button">↺ ${t("Reset","Reset")}</button>
        <button id="opsHdrLangBtn" class="btn btn-ghost" type="button">${lang === "en" ? "DE" : "EN"}</button>
      </div>
    `;
  }

  async function render() {
    const hostEl = document.getElementById("header-inner");
    if (!hostEl) return;

    if (timeTimer) { try { clearInterval(timeTimer); } catch (_) {} }
    timeTimer = null;

    hostEl.innerHTML = buildHeader({ username: "demo", roles: ["admin"] });

    const tick = () => {
      const el = document.getElementById("opsHdrTime");
      if (el) el.textContent = fmtDateTime(new Date());
    };
    tick();

    const me = await fetchMe();
    hostEl.innerHTML = buildHeader(me);
    tick();
    timeTimer = setInterval(tick, 10_000);

    // Language toggle
    const langBtn = document.getElementById("opsHdrLangBtn");
    if (langBtn) {
      langBtn.addEventListener("click", () => {
        const cur = getLang();
        const next = cur === "en" ? "de" : "en";
        try {
          if (typeof window.setOpsLang === "function") window.setOpsLang(next);
          else document.documentElement.lang = next;
        } catch (_) {}
        try { if (typeof window.applyI18n === "function") window.applyI18n(document); } catch (_) {}
        try { render(); } catch (_) {}
      });
    }

    // Reset button (ohne Reload)
    const resetBtn = document.getElementById("opsHdrReset");
    if (resetBtn) {
      resetBtn.addEventListener("click", async () => {
        const msg = t(
          "Demo-Reset: Alle Änderungen werden verworfen und die CSV wird neu geladen.\n\nFortfahren?",
          "Demo reset: All changes will be discarded and the CSV will be reloaded.\n\nContinue?"
        );
        if (!confirm(msg)) return;

        if (window.OpsDeck360Demo && typeof window.OpsDeck360Demo.reset === "function") {
          await window.OpsDeck360Demo.reset();
        } else {
          alert(t(
            "Reset ist noch nicht aktiv. Bitte Schritt 2 (Patch in ops-lagerverwaltung.js) umsetzen.",
            "Reset is not active yet. Please apply step 2 (patch in ops-lagerverwaltung.js)."
          ));
        }
      });
    }
  }

  window.addEventListener("ops:langchange", () => { try { render(); } catch (_) {} });

  if (document.readyState === "loading") {
    document.addEventListener("DOMContentLoaded", render, { once: true });
  } else {
    render();
  }
  
  // ---- Footer (DE/EN) ---------------------------------------------------
function ensureFooter(){
  if (document.getElementById("opsDemoFooter")) return;

  const footer = document.createElement("footer");
  footer.id = "opsDemoFooter";
  footer.style.cssText = `
    max-width: var(--content-max, 1360px);
    margin: 14px auto 20px;
    padding: 10px 16px;
    color: rgba(226,232,240,0.82);
    font-size: 12.5px;
    border-top: 1px solid rgba(255,255,255,0.08);
  `;

  const lang = (document.documentElement.lang || "de").toLowerCase().startsWith("en") ? "en" : "de";
  const text = (lang === "en")
    ? `Questions? Email Torsten Döpke (Dipl.-Wirt.-Inf.): <a href="mailto:info@opsdeck360.de" style="color:rgba(88,166,255,0.95);text-decoration:none;">info@opsdeck360.de</a>`
    : `Bei Fragen: Mail an Torsten Döpke (Diplom Wirt.-Info): <a href="mailto:info@opsdeck360.de" style="color:rgba(88,166,255,0.95);text-decoration:none;">info@opsdeck360.de</a>`;

  footer.innerHTML = text;

  // ans Ende der Seite, aber innerhalb des body
  document.body.appendChild(footer);
}

// Footer beim Start + bei Sprachwechsel
try { ensureFooter(); } catch(_) {}
window.addEventListener("ops:langchange", () => { 
  const f = document.getElementById("opsDemoFooter");
  if (f) f.remove();
  ensureFooter();
});
// ===== DEMO UI: Custom Select (works on iPhone Safari) + Demo Hint =====
(function(){
  if (window.OpsDemoUI) return;

  function langIsEn(){
    return String(document.documentElement.lang || "de").toLowerCase().startsWith("en");
  }

  function t(de, en){ return langIsEn() ? (en ?? de) : (de ?? en); }

  function dispatchChange(el){
    try {
      el.dispatchEvent(new Event("change", { bubbles:true }));
      el.dispatchEvent(new Event("input", { bubbles:true }));
    } catch(_) {}
  }

  function getLabelForSelect(sel){
    const opt = sel.options[sel.selectedIndex];
    return opt ? opt.textContent : "";
  }

  function closePopover(pop){
    if (!pop) return;
    try { pop.remove(); } catch(_) {}
  }

  function positionPopover(pop, anchor){
    const r = anchor.getBoundingClientRect();
    const gap = 8;
    const maxW = Math.min(520, Math.floor(window.innerWidth * 0.92));
    const w = Math.max(Math.min(r.width, maxW), 240);

    let left = r.left;
    left = Math.max(8, Math.min(left, window.innerWidth - w - 8));

    // Prefer below, fallback above
    let top = r.bottom + gap;
    const desiredH = Math.min(window.innerHeight * 0.54, 420) + 44;
    if (top + desiredH > window.innerHeight - 8) {
      top = Math.max(8, r.top - gap - desiredH);
    }

    pop.style.left = left + "px";
    pop.style.top = top + "px";
    pop.style.width = w + "px";
  }

  function buildPopover(sel, btn){
    const pop = document.createElement("div");
    pop.className = "opsx-select-pop";
    pop.setAttribute("role","dialog");
    pop.setAttribute("aria-modal","false");

    const title = (sel.getAttribute("aria-label") || sel.name || sel.id || t("Auswahl", "Select")).trim();
    pop.innerHTML = `
      <div class="opsx-select-pop-head">
        <div class="opsx-select-pop-title">${title}</div>
        <button type="button" class="opsx-select-pop-close">${t("Schließen","Close")}</button>
      </div>
      <div class="opsx-select-pop-list"></div>
    `;

    const list = pop.querySelector(".opsx-select-pop-list");
    const closeBtn = pop.querySelector(".opsx-select-pop-close");

    // Fill options (+ optgroups)
    let lastGroup = null;

    const addGroup = (label) => {
      const g = document.createElement("div");
      g.className = "opsx-optgroup";
      g.textContent = label;
      list.appendChild(g);
    };

    for (let i=0; i<sel.options.length; i++){
      const o = sel.options[i];
      const group = o.parentElement && o.parentElement.tagName === "OPTGROUP" ? o.parentElement.label : null;
      if (group && group !== lastGroup){
        addGroup(group);
        lastGroup = group;
      }

      const item = document.createElement("button");
      item.type = "button";
      item.className = "opsx-opt";
      item.textContent = o.textContent;

      const selected = (sel.value === o.value);
      item.setAttribute("aria-selected", selected ? "true" : "false");

      item.addEventListener("click", () => {
        sel.value = o.value;
        btn.querySelector(".opsx-select-text").textContent = getLabelForSelect(sel);
        dispatchChange(sel);
        closePopover(pop);
      });

      list.appendChild(item);
    }

    closeBtn.addEventListener("click", () => closePopover(pop));

    // outside click
    const onDocDown = (ev) => {
      if (!pop.contains(ev.target) && ev.target !== btn) closePopover(pop);
    };
    setTimeout(() => document.addEventListener("pointerdown", onDocDown, { capture:true, once:false }), 0);

    // cleanup when removed
    const obs = new MutationObserver(() => {
      if (!document.body.contains(pop)) {
        try { document.removeEventListener("pointerdown", onDocDown, { capture:true }); } catch(_) {}
        obs.disconnect();
      }
    });
    obs.observe(document.body, { childList:true, subtree:true });

    // reposition on resize/scroll
    const rePos = () => { if (document.body.contains(pop)) positionPopover(pop, btn); };
    window.addEventListener("resize", rePos, { passive:true });
    window.addEventListener("scroll", rePos, { passive:true, capture:true });

    const obs2 = new MutationObserver(() => {
      if (!document.body.contains(pop)) {
        window.removeEventListener("resize", rePos);
        window.removeEventListener("scroll", rePos, { capture:true });
        obs2.disconnect();
      }
    });
    obs2.observe(document.body, { childList:true, subtree:true });

    return pop;
  }

  function enhanceSelect(sel){
    if (!sel || sel.dataset.opsxEnhanced === "1") return;
    if (sel.closest(".opsx-select-wrap")) return;

    // only enhance visible selects
    if (sel.offsetParent === null && !sel.closest("dialog[open]")) return;

    const wrap = document.createElement("div");
    wrap.className = "opsx-select-wrap";

    // Create button UI
    const btn = document.createElement("button");
    btn.type = "button";
    btn.className = "opsx-select-btn";
    btn.innerHTML = `<span class="opsx-select-text"></span><span class="opsx-select-caret">▾</span>`;
    btn.querySelector(".opsx-select-text").textContent = getLabelForSelect(sel);

    // Disabled support
    const syncDisabled = () => {
      const dis = !!sel.disabled;
      btn.setAttribute("aria-disabled", dis ? "true" : "false");
      btn.disabled = dis;
    };
    syncDisabled();

    // keep UI in sync if select changes elsewhere
    sel.addEventListener("change", () => {
      btn.querySelector(".opsx-select-text").textContent = getLabelForSelect(sel);
      syncDisabled();
    });

    btn.addEventListener("click", () => {
      if (sel.disabled) return;

      // close any open popovers
      document.querySelectorAll(".opsx-select-pop").forEach(p => p.remove());

      const pop = buildPopover(sel, btn);
      document.body.appendChild(pop);
      positionPopover(pop, btn);

      // focus first selected item for keyboard
      setTimeout(() => {
        const selected = pop.querySelector('.opsx-opt[aria-selected="true"]');
        (selected || pop.querySelector(".opsx-opt"))?.focus?.();
      }, 0);
    });

    // Replace in DOM
    const parent = sel.parentNode;
    parent.insertBefore(wrap, sel);
    wrap.appendChild(sel);
    wrap.appendChild(btn);

    // hide native
    sel.classList.add("opsx-select-native");
    sel.dataset.opsxEnhanced = "1";
  }

  function enhanceAll(root=document){
    // In dialogs + in Aktion/Masken + generell
    root.querySelectorAll("select").forEach(enhanceSelect);
  }

  // Watch for new dialogs / dynamic content
  const mo = new MutationObserver((mut) => {
    for (const m of mut){
      for (const n of m.addedNodes){
        if (!(n instanceof HTMLElement)) continue;
        if (n.matches && (n.matches("dialog") || n.querySelector?.("dialog"))) {
          enhanceAll(n);
        }
        // when any DOM injected (e.g. action dropdown creates select)
        enhanceAll(n);
      }
    }
  });

  function start(){
    enhanceAll(document);
    mo.observe(document.body, { childList:true, subtree:true });
  }

  // Demo hint (einmal pro Tab)
  function showDemoHintOnce(){
    try {
      if (sessionStorage.getItem("ops_demo_hint_shown") === "1") return;
      sessionStorage.setItem("ops_demo_hint_shown", "1");
    } catch(_) {}

    const box = document.createElement("div");
    box.style.cssText = `
      position: fixed;
      left: 50%;
      bottom: 18px;
      transform: translateX(-50%);
      z-index: 6000;
      max-width: min(720px, 92vw);
      padding: 12px 14px;
      border-radius: 14px;
      background: rgba(15, 23, 42, 0.88);
      border: 1px solid rgba(88, 166, 255, 0.30);
      box-shadow: 0 16px 44px rgba(0,0,0,0.62);
      color: rgba(226,232,240,0.94);
      backdrop-filter: blur(10px);
      display:flex;
      align-items:flex-start;
      gap: 10px;
      font-size: 13px;
      line-height: 1.25;
    `;
    box.innerHTML = `
      <div style="font-weight:900;letter-spacing:.06em;">DEMO</div>
      <div style="opacity:.95;">
        ${t(
          "Änderungen werden nicht dauerhaft gespeichert. Der Reset-Button setzt alles zurück und lädt die CSV neu.",
          "Changes are not permanently saved. The Reset button restores everything and reloads the CSV."
        )}
      </div>
      <button type="button" class="btn btn-ghost" style="min-height:34px;padding:6px 10px;margin-left:auto;">OK</button>
    `;
    const ok = box.querySelector("button");
    ok.addEventListener("click", () => box.remove());
    document.body.appendChild(box);
    setTimeout(() => { try { box.remove(); } catch(_) {} }, 12000);
  }

  window.OpsDemoUI = { enhanceAll, showDemoHintOnce };

  if (document.readyState === "loading") {
    document.addEventListener("DOMContentLoaded", () => { start(); showDemoHintOnce(); }, { once:true });
  } else {
    start(); showDemoHintOnce();
  }

  // Re-run on language changes (labels may change)
  window.addEventListener("ops:langchange", () => {
    try { enhanceAll(document); } catch(_) {}
    try { showDemoHintOnce(); } catch(_) {}
  });

})();

// DEMO: Keepalive damit der Launcher erkennt, ob das Browserfenster noch offen ist
(function(){
  if (!window.OPS_DEMO) return;

  const ping = () => {
    fetch("/__alive?ts=" + Date.now(), { cache: "no-store" }).catch(()=>{});
  };

  ping();
  setInterval(ping, 4000);

  // optional: schnelleres Signal beim Schließen
  window.addEventListener("beforeunload", () => {
    try { navigator.sendBeacon("/__alive?bye=1"); } catch(_) {}
  });
})();

})();
